
variants = { # chain environments
            "2-chain": (False, True, "2-chain", -1, 1, 4,4, True, False, True, 0.0, "Gaussian", 0.000, True, -1, -1, "", "", 0.0, 50, "linear", -1, -1.0),
            "3-chain": (False, True, "3-chain", -1, 1, 4,4, True, False, True, 0.0, "Gaussian", 0.000, True, -1, -1, "", "", 0.0, 50, "linear", -1, -1.0),
            "2-multi-chain": (False, True, "2-multi-chain", -1, 1, 4,4, True, False, True, 0.0, "Gaussian", 0.000, True, -1, -1, "", "$Target", 0.0, 50, "linear", -1, -1.0),
            "3-multi-chain": (False, True, "3-multi-chain", -1, 1, 4,4, True, False, True, 0.0, "Gaussian", 0.000, True, -1, -1, "", "$Target", 0.0, 50, "linear", -1, -1.0),
            "3-c-small": (False, True, "3-chain", -1, 1, 4,4, True, False, True, 0.0, "Gaussian", 0.000, False, -1, -1, "", "$Target", 0.0, 50, "linear", -1, -1.0),
            "4-chain": (False, True, "4-chain", -1, 1, 4,4, True, False, True, 0.0, "Gaussian", 0.007, True, -1, -1, "", "$Target", 0.5, 50, "linear", -1, -1.0),
            # No passive model, for debugging
            "1-in-nrp": (False, False, "3-chain", -1, 1, 4,4, False, True, True, 0.0, "Gaussian", 0.000, False, -1, -1, "", "", 0.0, 50, "linear", -1, -1.0),
            # single in envrionments
            "1-in": (False, False, "3-chain", -1, 1, 4,4, False, True, True, 0.0, "Gaussian", 0.000, True, -1, -1, "", "", 0.0, 50, "linear", -1, -1.0),
            "2-in": (False, False, "2-inchain", -1, 1, 4,4, False, True, True, 0.0, "Gaussian", 0.000, True, -1, -1, "", "", 0.0, 50, "linear", -1, -1.0),
            "3-in": (False, False, "3-inchain", -1, 1, 4,4, False, True, True, 0.0, "Gaussian", 0.000, True, -1, -1, "", "", 0.0, 50, "linear", -1, -1.0),
            "4-in": (False, False, "4-inchain", -1, 1, 4,4, False, True, True, 0.0, "Gaussian", 0.000, True, -1, -1, "", "", 0.0, 50, "linear", -1, -1.0),
            "many-in": (False, False, "6-multi-chain", -1, 1, 4,4, False, True, True, 0.0, "Gaussian", 0.000, True, -1, -1, "", "", 0.0, 50, "linear", -1, -1.0),
            # dynamics free
            "1-in-ndym": (False, False, "3-chain", -1, 1, 4,4, False, False, True, 0.0, "Gaussian", 0.000, True, -1, -1, "", "", 0.0, 50, "linear", -1, -1.0),
            # single transition
            "1-in-nt": (False, False, "3-chain", -1, 1, 4,4, False, True, True, 0.0, "Gaussian", 0.000, True, -1, -1, "", "", 0.0, 2, "linear", -1, -1.0),
            # high dimension
            "1-hdim": (False, False, "3-chain", -1, 1, 20,20, False, True, True, 0.0, "Gaussian", 0.000, True, -1, -1, "", "", 0.0, 50, "linear", -1, -1.0),
            # rare interaction environments
            "1-rare": (False, False, "3-chain", -1, 1, 4,4, False, True, True, 0.23, "Gaussian", 0.000, True, -1, -1, "", "", 0.0, 50, "linear", -1, -1.0),
            "2-rare": (False, False, "2-inchain", -1, 1, 4,4, False, True, True, 0.23, "Gaussian", 0.000, True, -1, -1, "", "", 0.0, 50, "linear", -1, -1.0),
            "3-rare": (False, False, "3-inchain", -1, 1, 4,4, False, True, True, 0.23, "Gaussian", 0.000, True, -1, -1, "", "", 0.0, 50, "linear", -1, -1.0),
            "4-rare": (False, False, "4-inchain", -1, 1, 4,4, False, True, True, 0.23, "Gaussian", 0.000, True, -1, -1, "", "", 0.0, 50, "linear", -1, -1.0),
            "many-rare": (False, False, "6-multi-chain", -1, 1, 4,4, False, True, True, 0.33, "Gaussian", 0.000, True, -1, -1, "", "", 0.0, 50, "linear", -1, -1.0),
            # multi input environments
            "multi-in": (False, False, "2-multi", -1, 1, 4,4, True, True, True, 0.0, "Gaussian", 0.000, True, -1, -1, "", "", 0.0, 50, "linear", -1, -1.0),
            # null domains (first is no passive dynamics)
            "1-in-n-nrp": (False, True, "3-chain", -1, 1, 4,4, False, True, True, 0.0, "Gaussian", 0.000, False,2, 3, "$Target", "", 0.0, 50, "linear", -1, -1.0),
            "2-in-n": (False, True, "2-inchain", -1, 1, 4,4, False, True, True, 0.0, "Gaussian", 0.000, True, 2, 4, "$Target", "", 0.0, 50, "linear", -1, -1.0),
            "3-in-n": (False, True, "3-inchain", -1, 1, 4,4, False, True, True, 0.0, "Gaussian", 0.000, True, 2, 5, "$Target", "", 0.0, 50, "linear", -1, -1.0),
            "4-in-n": (False, True, "4-inchain", -1, 1, 4,4, False, True, True, 0.0, "Gaussian", 0.000, True, 2, 6, "$Target", "", 0.0, 50, "linear", -1, -1.0),
            "many-in-n": (False, True, "6-multi-chain", -1, 1, 4,4, False, True, True, 0.0, "Gaussian", 0.000, True,3, 7, "$Target", "", 0.0, 50, "linear", -1, -1.0),
            "1-in-n": (False, True, "3-chain", -1, 1, 4,4, False, True, True, 0.0, "Gaussian", 0.000, True,2, 3, "$Target", "", 0.0, 50, "linear", -1, -1.0),
            # single in envrionments nonlinear dynamics
            "1-in-nl": (False, False, "3-chain", -1, 1, 4,4, False, True, True, 0.0, "Gaussian", 0.000, True, -1, -1, "", "", 0.0, 50, "sin", -1, -1.0),
            "2-in-nl": (False, False, "2-inchain", -1, 1, 4,4, False, True, True, 0.0, "Gaussian", 0.000, True, -1, -1, "", "", 0.0, 50, "sin", -1, -1.0),
            "3-in-nl": (False, False, "3-inchain", -1, 1, 4,4, False, True, True, 0.0, "Gaussian", 0.000, True, -1, -1, "", "", 0.0, 50, "sin", -1, -1.0),
            "4-in-nl": (False, False, "4-inchain", -1, 1, 4,4, False, True, True, 0.0, "Gaussian", 0.000, True, -1, -1, "", "", 0.0, 50, "sin", -1, -1.0),
            "many-in-nl": (False, False, "6-multi-chain", -1, 1, 4,4, False, True, True, 0.0, "Gaussian", 0.000, True, -1, -1, "", "", 0.0, 50, "sin", -1, -1.0)}

# discrete_actions, allow uncontrollable, graph_skeleton, num_nodes (only used for random graph skeleton), 
# multi_instanced, min dim, max dim, instant_update, relate_dynamics, conditional, conditional_value
# distribution, noise_percentage, require_passive (dynamics), min live, max live, force_live, intervention_state, 
# intervention_rate, horizon, nonlinear type, goal dimension type, goal epsilon (gets reset, -1 for unused)

def parse_edges(graph_skeleton):
    if graph_skeleton == "rand":
        # TODO: generate a random skeleton
        pass
    elif graph_skeleton == "2-chain":
        return [("Action", "$Target")], ["Action", "$Target", "Reward", "Done"]
    elif graph_skeleton == "3-chain":
        return [("Action", "$B"), ("$B", "$Target")], ["Action", "$B", "$Target", "Reward", "Done"]
    elif graph_skeleton == "4-chain":
        return [("Action", "$B"), ("$B", "$D"), ("$D", "$Target")], ["Action", "$B", "$Target", "$D", "Reward", "Done"]
    elif graph_skeleton == "2-in":
        return [("Action", "$Target"), ("$B", "$Target")], ["Action", "$B", "$Target", "Reward", "Done"]
    elif graph_skeleton == "2-inchain":
        return [("Action", "$B"),("$B", "$Target"), ("$D", "$Target")], ["Action", "$B", "$Target", "$D", "Reward", "Done"]
    elif graph_skeleton == "3-inchain":
        return [("Action", "$B"),("$E", "$Target"), ("$B", "$Target"), ("$D", "$Target")], ["Action", "$B", "$Target", "$D", "$E", "Reward", "Done"]
    elif graph_skeleton == "4-inchain":
        return [("Action", "$B"),("$E", "$Target"), ("$B", "$Target"), ("$D", "$Target"), ("$F", "$Target")], ["Action", "$B", "$Target", "$D", "$E","$F", "Reward", "Done"]
    elif graph_skeleton == "2-multi":
        return [("Action", "$B"),("$B", "$E", "$D", "$Target")], ["Action", "$B", "$Target", "$D", "$E", "Reward", "Done"]
    elif graph_skeleton == "2-multi-chain":
        return [("Action", "$B"), ("Action", "$C"), ("$C", "$B", "$Target")], ["Action", "$B", "$C", "$Target", "Reward", "Done"]
    elif graph_skeleton == "3-multi-chain":
        return [("Action", "$B"), ("$C", "$A"), ("$C", "$D"), ("$A", "$B", "$Target"), ("$D", "$Target")], ["Action", "$A", "$B", "$C", "$D", "$Target", "Reward", "Done"]
    elif graph_skeleton == "6-multi-chain":
        return [("Action", "$B"), 
                ("$A", "$Target"), 
                ("$B", "$D"), 
                ("$B", "$Target"), 
                ("$D", "$Target"), 
                ("$E", "$Target"), 
                ("$F", "$Target"), 
                ("$Target", "$F"),
                ("$B", "$E")], ["Action", "$A", "$B", "$D", "$E", "$F", "$Target", "Reward", "Done"]
